// Jasmine Unit Testing Suite
define([
    'backbone',
    'models/resources-collection',
],
function (Backbone, Resources) {
    'use strict';

    describe('Resources', function () {
        var resources;

        beforeEach(function () {
            resources = new Resources();
        });

        it('parses links', function () {
            resources.set({
                'links': [
                    {
                        'title': 'patient',
                        'href': '/PatientViewerServices/rest/patient/{assigning-authority}/{patient-id}',
                    },
                    {
                        'title': 'token',
                        'href': '/AuthorizationServices/rest/token',
                    },
                ],
            }, {parse: true});

            expect(resources.length).toEqual(2);
        });

        describe('model', function () {
            it('can formatHref()', function () {
                resources.add({
                    'title': 'patient',
                    'href': '/PatientViewerServices/rest/patient/{assigning-authority}/{patient-id}',
                });

                expect(resources.get('patient').formatHref({
                    'assigning-authority': 'dfn-1234',
                    'patient-id': '1111',
                })).toBe('/PatientViewerServices/rest/patient/dfn-1234/1111');
            });
        });
    });
});
